/*
 * PropertyListImpl.java
 *
 * Created on March 3, 2003, 11:40 AM
 */

package nom.DannyBrewer.utils;

/**
 *
 * @author  danny brewer
 */
public class PropertyListNonPersistent
		extends PropertyListImplHelper
		implements PropertyList
{
    //----------------------------------------------------------------------
    //  Constructor
    //----------------------------------------------------------------------

	public PropertyListNonPersistent() {
		zapProperties();
	}
	
    //----------------------------------------------------------------------
    //  Public API
    //----------------------------------------------------------------------
	
	public void zapProperties() {
		properties = new java.util.HashMap( 0 );
	}

	
	
    //----------------------------------------------------------------------
    //  PropertyList interface
	//	(The part not implemented by PropertyListImplHelper)
    //----------------------------------------------------------------------
	
	public Object getProperty( String propName ) {
		return properties.get( propName );
	}
	
	public Object getProperty( String propName, Object defaultValue ) {
		Object value = properties.get( propName );
		if( value != null ) {
			return value;
		} else {
			return defaultValue;
		}
	}
	
	public void setProperty( String propName, Object value ) {
		properties.put( propName, value );
	}

	
	//----------------------------------------------------------------------
    //  Internal Support
    //----------------------------------------------------------------------

	java.util.HashMap properties = null;
}
